#ifdef WIN32

#include "CalendarIntegration.h"


CCalendarIntegration::CCalendarIntegration(void)
{
}


CCalendarIntegration::~CCalendarIntegration(void)
{
}

std::string CCalendarIntegration::GetDefaultMailClient()
{
	std::string strDefMail = "";
	strDefMail = GetDefaultMailClientFromRegedit(HKEY_CURRENT_USER);
	if (""== strDefMail)
	{
		strDefMail = GetDefaultMailClientFromRegedit(HKEY_LOCAL_MACHINE);
	}
	return strDefMail;
}

std::string CCalendarIntegration::GetDefaultMailClientFromRegedit(HKEY iRegBranch)
{
	std::string strDefMail = "";

	LONG lRet;
	HKEY hKey;
	lRet = RegOpenKeyEx( iRegBranch,
		TEXT("SOFTWARE\\Clients\\Mail"), 0, KEY_READ, &hKey );

	if( lRet == ERROR_SUCCESS )
	{
		DWORD dType, dSize;
		CHAR szVal[MAX_PATH];

		dSize = sizeof(szVal);
		memset(szVal, 0, dSize);

		if ( RegQueryValueExA(hKey,NULL,NULL,&dType,(LPBYTE)szVal, &dSize) == ERROR_SUCCESS )
		{
			strDefMail = std::string(&szVal[0]);
		}		
	}

	RegCloseKey( hKey );

	return strDefMail;
}

#endif